/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.model.baked.chiseled;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Function;
import mod.chiselsandbits.api.blockinformation.BlockInformation;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.accessor.sortable.IPositionMutator;
import mod.chiselsandbits.api.profiling.IProfilerSection;
import mod.chiselsandbits.client.culling.ICullTest;
import mod.chiselsandbits.client.model.baked.base.BaseBakedBlockModel;
import mod.chiselsandbits.client.model.baked.chiseled.ChiselRenderType;
import mod.chiselsandbits.client.model.baked.chiseled.ChiseledBlockModelBuilder;
import mod.chiselsandbits.client.model.baked.face.ChiselsAndBitsBakedQuad;
import mod.chiselsandbits.client.model.baked.face.FaceManager;
import mod.chiselsandbits.client.model.baked.face.FaceRegion;
import mod.chiselsandbits.client.model.baked.face.IFaceBuilder;
import mod.chiselsandbits.client.model.baked.face.model.ModelQuadLayer;
import mod.chiselsandbits.profiling.ProfilingManager;
import mod.chiselsandbits.utils.ModelUtil;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1086;
import net.minecraft.class_1087;
import net.minecraft.class_1160;
import net.minecraft.class_1723;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_296;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3665;
import net.minecraft.class_777;
import net.minecraft.class_783;
import net.minecraft.class_787;
import net.minecraft.class_796;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChiseledBlockBakedModel
extends BaseBakedBlockModel {
    public static final ChiseledBlockBakedModel EMPTY = new ChiseledBlockBakedModel(BlockInformation.AIR, ChiselRenderType.SOLID, null, vector3d -> BlockInformation.AIR, 0L);
    private static final int[][] faceVertMap = new int[6][4];
    private static final float[][][] quadMapping = new float[6][4][6];
    private static final class_2350[] X_Faces = new class_2350[]{class_2350.field_11034, class_2350.field_11039};
    private static final class_2350[] Y_Faces = new class_2350[]{class_2350.field_11036, class_2350.field_11033};
    private static final class_2350[] Z_Faces = new class_2350[]{class_2350.field_11035, class_2350.field_11043};
    private final ChiselRenderType chiselRenderType;
    private class_777[] up;
    private class_777[] down;
    private class_777[] north;
    private class_777[] south;
    private class_777[] east;
    private class_777[] west;
    private class_777[] generic;

    private List<class_777> getList(class_2350 side) {
        if (side != null) {
            switch (side) {
                case field_11033: {
                    return this.asList(this.down);
                }
                case field_11034: {
                    return this.asList(this.east);
                }
                case field_11043: {
                    return this.asList(this.north);
                }
                case field_11035: {
                    return this.asList(this.south);
                }
                case field_11036: {
                    return this.asList(this.up);
                }
                case field_11039: {
                    return this.asList(this.west);
                }
            }
        }
        return this.asList(this.generic);
    }

    private List<class_777> asList(class_777[] array) {
        if (array == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(array);
    }

    public ChiseledBlockBakedModel(BlockInformation state, ChiselRenderType layer, IAreaAccessor data, Function<class_243, BlockInformation> neighborStateSupplier, long primaryStateRenderSeed) {
        this.chiselRenderType = layer;
        class_1087 originalModel = null;
        if (state != null && !state.isAir()) {
            originalModel = class_310.method_1551().method_1541().method_3351().method_3335(state.getBlockState());
        }
        if (originalModel != null && data != null) {
            boolean shouldLayerRender;
            try (IProfilerSection ignoredLayerCheck = ProfilingManager.getInstance().withSection("check");){
                shouldLayerRender = layer.isRequiredForRendering(data);
            }
            if (shouldLayerRender) {
                ChiseledBlockModelBuilder builder = new ChiseledBlockModelBuilder();
                try (IProfilerSection ignoredFaceGeneration = ProfilingManager.getInstance().withSection("facegeneration");){
                    this.generateFaces(builder, data, neighborStateSupplier, primaryStateRenderSeed);
                }
                try (IProfilerSection ignoredFinalize = ProfilingManager.getInstance().withSection("finalize");){
                    this.up = builder.getSide(class_2350.field_11036);
                    this.down = builder.getSide(class_2350.field_11033);
                    this.east = builder.getSide(class_2350.field_11034);
                    this.west = builder.getSide(class_2350.field_11039);
                    this.north = builder.getSide(class_2350.field_11043);
                    this.south = builder.getSide(class_2350.field_11035);
                    this.generic = builder.getSide(null);
                }
            }
        }
    }

    public boolean isEmpty() {
        boolean trulyEmpty = this.getList(null).isEmpty();
        for (class_2350 e : class_2350.values()) {
            trulyEmpty = trulyEmpty && this.getList(e).isEmpty();
        }
        return trulyEmpty;
    }

    IFaceBuilder getBuilder() {
        return new ChiselsAndBitsBakedQuad.Builder(class_290.field_1590);
    }

    private void generateFaces(ChiseledBlockModelBuilder builder, IAreaAccessor accessor, Function<class_243, BlockInformation> neighborStateSupplier, long primaryStateRenderSeed) {
        ArrayList<List<FaceRegion>> resultingFaces = new ArrayList<List<FaceRegion>>();
        try (IProfilerSection ignoredFaceProcessing = ProfilingManager.getInstance().withSection("processing");){
            try (IProfilerSection ignoredXFaces = ProfilingManager.getInstance().withSection("x");){
                this.processFaces(accessor, resultingFaces, IPositionMutator.xzy(), X_Faces, class_243::method_10216, class_243::method_10215, neighborStateSupplier);
            }
            ignoredXFaces = ProfilingManager.getInstance().withSection("y");
            try {
                this.processFaces(accessor, resultingFaces, IPositionMutator.zxy(), Y_Faces, class_243::method_10214, class_243::method_10215, neighborStateSupplier);
            }
            finally {
                if (ignoredXFaces != null) {
                    ignoredXFaces.close();
                }
            }
            ignoredXFaces = ProfilingManager.getInstance().withSection("z");
            try {
                this.processFaces(accessor, resultingFaces, IPositionMutator.zyx(), Z_Faces, class_243::method_10215, class_243::method_10214, neighborStateSupplier);
            }
            finally {
                if (ignoredXFaces != null) {
                    ignoredXFaces.close();
                }
            }
        }
        try (IProfilerSection ignoredFaceBuilding = ProfilingManager.getInstance().withSection("building");){
            double[] to = new double[3];
            double[] from = new double[3];
            float[] uvs = new float[8];
            float[] pos = new float[3];
            IFaceBuilder faceBuilder = this.getBuilder();
            try (IProfilerSection ignoredMerging = ProfilingManager.getInstance().withSection("merging");){
                for (List list : resultingFaces) {
                    this.mergeFaces(list);
                }
            }
            try (IProfilerSection ignoredQuadGeneration = ProfilingManager.getInstance().withSection("quadGeneration");){
                for (List list : resultingFaces) {
                    for (FaceRegion region : list) {
                        class_2350 myFace = region.getFace();
                        ChiseledBlockBakedModel.offsetVec(to, region.getMaxX(), region.getMaxY(), region.getMaxZ());
                        ChiseledBlockBakedModel.offsetVec(from, region.getMinX(), region.getMinY(), region.getMinZ());
                        ModelQuadLayer[] mpc = FaceManager.getInstance().getCachedFace(region.getBlockInformation(), myFace, this.chiselRenderType.layer, primaryStateRenderSeed);
                        if (mpc == null) continue;
                        for (ModelQuadLayer pc : mpc) {
                            class_293 builderFormat = faceBuilder.getFormat();
                            faceBuilder.begin();
                            faceBuilder.setFace(myFace, pc.getTint());
                            float maxLightmap = 4.882887E-4f;
                            this.getFaceUvs(uvs, myFace, from, to, pc.getUvs());
                            for (int vertNum = 0; vertNum < 4; ++vertNum) {
                                block46: for (int elementIndex = 0; elementIndex < builderFormat.method_1357().size(); ++elementIndex) {
                                    class_296 element = (class_296)builderFormat.method_1357().get(elementIndex);
                                    switch (element.method_1382()) {
                                        case field_1633: {
                                            this.getVertexPos(pos, myFace, vertNum, to, from);
                                            faceBuilder.put(elementIndex, pos[0], pos[1], pos[2]);
                                            continue block46;
                                        }
                                        case field_1632: {
                                            int cb = pc.getColor();
                                            faceBuilder.put(elementIndex, this.byteToFloat(cb >> 16), this.byteToFloat(cb >> 8), this.byteToFloat(cb), this.NotZero(this.byteToFloat(cb >> 24)));
                                            continue block46;
                                        }
                                        case field_1635: {
                                            float normalShift = 0.999f;
                                            faceBuilder.put(elementIndex, 0.999f * (float)myFace.method_10148(), 0.999f * (float)myFace.method_10164(), 0.999f * (float)myFace.method_10165());
                                            continue block46;
                                        }
                                        case field_1636: {
                                            if (element.method_1385() == 2) {
                                                float v = 4.882887E-4f * (float)Math.max(0, Math.min(15, pc.getLight()));
                                                faceBuilder.put(elementIndex, v, v);
                                                continue block46;
                                            }
                                            float u = uvs[faceVertMap[myFace.method_10146()][vertNum] * 2];
                                            float v = uvs[faceVertMap[myFace.method_10146()][vertNum] * 2 + 1];
                                            faceBuilder.put(elementIndex, pc.getSprite().method_4580((double)u), pc.getSprite().method_4570((double)v));
                                            continue block46;
                                        }
                                        default: {
                                            faceBuilder.put(elementIndex, new float[0]);
                                        }
                                    }
                                }
                            }
                            if (region.isEdge()) {
                                builder.getList(myFace).add(faceBuilder.create(pc.getSprite()));
                                continue;
                            }
                            builder.getList(null).add(faceBuilder.create(pc.getSprite()));
                        }
                    }
                }
            }
        }
    }

    private float NotZero(float byteToFloat) {
        if (byteToFloat < 1.0E-5f) {
            return 1.0f;
        }
        return byteToFloat;
    }

    private float byteToFloat(int i) {
        return (float)(i & 0xFF) / 255.0f;
    }

    private void mergeFaces(List<FaceRegion> src) {
        boolean restart;
        block0: do {
            restart = false;
            int size = src.size();
            int sizeMinusOne = size - 1;
            for (int x = 0; x < sizeMinusOne; ++x) {
                FaceRegion faceA = src.get(x);
                for (int y = x + 1; y < size; ++y) {
                    FaceRegion faceB = src.get(y);
                    if (!faceA.extend(faceB)) continue;
                    src.set(y, src.get(sizeMinusOne));
                    src.remove(sizeMinusOne);
                    restart = true;
                    continue block0;
                }
            }
        } while (restart);
    }

    private void processFaces(final IAreaAccessor accessor, final List<List<FaceRegion>> resultingRegions, IPositionMutator analysisOrder, class_2350[] potentialDirections, final Function<class_243, Double> regionBuildingAxisValueExtractor, final Function<class_243, Double> faceBuildingAxisValueExtractor, final Function<class_243, BlockInformation> neighborStateSupplier) {
        final ArrayList regions = Lists.newArrayList();
        final ICullTest test = this.chiselRenderType.getTest();
        for (final class_2350 facing : potentialDirections) {
            final FaceBuildingState state = new FaceBuildingState();
            accessor.forEachWithPositionMutator(analysisOrder, new Consumer<IStateEntryInfo>(){

                @Override
                public void accept(IStateEntryInfo stateEntryInfo) {
                    if (!ChiseledBlockBakedModel.this.chiselRenderType.isRequiredForRendering(stateEntryInfo)) {
                        return;
                    }
                    if (state.getRegionBuildingAxisValue() != ((Double)regionBuildingAxisValueExtractor.apply(stateEntryInfo.getStartPoint())).doubleValue()) {
                        if (!regions.isEmpty()) {
                            resultingRegions.add(Lists.newArrayList((Iterable)regions));
                        }
                        regions.clear();
                        state.setCurrentRegion(null);
                    }
                    state.setRegionBuildingAxisValue((Double)regionBuildingAxisValueExtractor.apply(stateEntryInfo.getStartPoint()));
                    if (state.getFaceBuildingAxisValue() != ((Double)faceBuildingAxisValueExtractor.apply(stateEntryInfo.getStartPoint())).doubleValue()) {
                        state.setCurrentRegion(null);
                    }
                    state.setFaceBuildingAxisValue((Double)faceBuildingAxisValueExtractor.apply(stateEntryInfo.getStartPoint()));
                    Optional<FaceRegion> potentialRegionData = ChiseledBlockBakedModel.this.buildFaceRegion(accessor, facing, stateEntryInfo, test, neighborStateSupplier);
                    if (potentialRegionData.isEmpty()) {
                        state.setCurrentRegion(null);
                        return;
                    }
                    if (state.getCurrentRegion() != null && state.getCurrentRegion().extend(potentialRegionData.get())) {
                        return;
                    }
                    state.setCurrentRegion(potentialRegionData.get());
                    regions.add(potentialRegionData.get());
                }
            });
            if (!regions.isEmpty()) {
                resultingRegions.add(Lists.newArrayList((Iterable)regions));
            }
            regions.clear();
        }
    }

    private Optional<FaceRegion> buildFaceRegion(IAreaAccessor blob, class_2350 facing, IStateEntryInfo target, ICullTest test, Function<class_243, BlockInformation> neighborStateSupplier) {
        return Optional.of(target).filter(stateEntryInfo -> {
            class_243 faceOffSet = class_243.method_24954((class_2382)facing.method_10163()).method_18805((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit());
            class_243 offsetTarget = stateEntryInfo.getStartPoint().method_1019(faceOffSet);
            if (!blob.isInside(offsetTarget)) {
                BlockInformation externalNeighborState = (BlockInformation)neighborStateSupplier.apply(offsetTarget);
                return Optional.of(externalNeighborState).map(neighborState -> test.isVisible(stateEntryInfo.getBlockInformation(), (BlockInformation)neighborState)).orElseGet(() -> !stateEntryInfo.getBlockInformation().isAir());
            }
            return blob.getInAreaTarget(offsetTarget).map(IStateEntryInfo::getBlockInformation).map(neighborState -> test.isVisible(stateEntryInfo.getBlockInformation(), (BlockInformation)neighborState)).orElseGet(() -> !stateEntryInfo.getBlockInformation().isAir());
        }).map(stateEntryInfo -> {
            class_243 faceOffSet = class_243.method_24954((class_2382)facing.method_10163()).method_18805((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit());
            class_243 offsetTarget = stateEntryInfo.getStartPoint().method_1019(faceOffSet);
            return FaceRegion.createFrom3DObjectWithFacing(stateEntryInfo.getStartPoint(), stateEntryInfo.getEndPoint(), facing, stateEntryInfo.getBlockInformation(), !blob.isInside(offsetTarget));
        });
    }

    private void getVertexPos(float[] pos, class_2350 side, int vertNum, double[] to, double[] from) {
        float[] interpos = quadMapping[side.ordinal()][vertNum];
        pos[0] = (float)(to[0] * 16.0 * (double)interpos[0] + from[0] * 16.0 * (double)interpos[1]);
        pos[1] = (float)(to[1] * 16.0 * (double)interpos[2] + from[1] * 16.0 * (double)interpos[3]);
        pos[2] = (float)(to[2] * 16.0 * (double)interpos[4] + from[2] * 16.0 * (double)interpos[5]);
    }

    private void getFaceUvs(float[] uvs, class_2350 face, double[] from, double[] to, float[] quadsUV) {
        float to_u = 0.0f;
        float to_v = 0.0f;
        float from_u = 0.0f;
        float from_v = 0.0f;
        switch (face) {
            case field_11033: 
            case field_11036: {
                to_u = (float)to[0];
                to_v = (float)to[2];
                from_u = (float)from[0];
                from_v = (float)from[2];
                break;
            }
            case field_11043: 
            case field_11035: {
                to_u = (float)to[0];
                to_v = (float)to[1];
                from_u = (float)from[0];
                from_v = (float)from[1];
                break;
            }
            case field_11034: 
            case field_11039: {
                to_u = (float)to[1];
                to_v = (float)to[2];
                from_u = (float)from[1];
                from_v = (float)from[2];
                break;
            }
        }
        uvs[0] = this.u(quadsUV, to_u, to_v) * 16.0f;
        uvs[1] = this.v(quadsUV, to_u, to_v) * 16.0f;
        uvs[2] = this.u(quadsUV, from_u, to_v) * 16.0f;
        uvs[3] = this.v(quadsUV, from_u, to_v) * 16.0f;
        uvs[4] = this.u(quadsUV, from_u, from_v) * 16.0f;
        uvs[5] = this.v(quadsUV, from_u, from_v) * 16.0f;
        uvs[6] = this.u(quadsUV, to_u, from_v) * 16.0f;
        uvs[7] = this.v(quadsUV, to_u, from_v) * 16.0f;
    }

    float u(float[] src, float inU, float inV) {
        float inv = 1.0f - inU;
        float u1 = src[0] * inU + inv * src[2];
        float u2 = src[4] * inU + inv * src[6];
        return u1 * inV + (1.0f - inV) * u2;
    }

    float v(float[] src, float inU, float inV) {
        float inv = 1.0f - inU;
        float v1 = src[1] * inU + inv * src[3];
        float v2 = src[5] * inU + inv * src[7];
        return v1 * inV + (1.0f - inV) * v2;
    }

    private static void offsetVec(double[] result, double toX, double toY, double toZ) {
        result[0] = toX;
        result[1] = toY;
        result[2] = toZ;
    }

    @NotNull
    public List<class_777> method_4707(@Nullable class_2680 state, @Nullable class_2350 side, @NotNull Random rand) {
        return this.getList(side);
    }

    public boolean method_24304() {
        return true;
    }

    @NotNull
    public class_1058 method_4711() {
        return (class_1058)class_310.method_1551().method_1549(class_1723.field_21668).apply(class_1047.method_4539());
    }

    static {
        class_1160 to = new class_1160(0.0f, 0.0f, 0.0f);
        class_1160 from = new class_1160(16.0f, 16.0f, 16.0f);
        for (class_2350 myFace : class_2350.values()) {
            class_796 faceBakery = new class_796();
            class_1086 mr = class_1086.field_5350;
            float[] defUVs = new float[]{0.0f, 0.0f, 1.0f, 1.0f};
            class_787 uv = new class_787(defUVs, 0);
            class_783 bpf = new class_783(myFace, 0, "", uv);
            class_1058 texture = (class_1058)class_310.method_1551().method_1549(class_1723.field_21668).apply(new class_2960("missingno"));
            class_777 q = faceBakery.method_3468(to, from, bpf, texture, myFace, (class_3665)mr, null, true, new class_2960("chiselsandbits", "chiseled_block"));
            int[] vertData = q.method_3357();
            int a = 0;
            int b = 2;
            switch (myFace) {
                case field_11043: 
                case field_11035: {
                    a = 0;
                    b = 1;
                    break;
                }
                case field_11034: 
                case field_11039: {
                    a = 1;
                    b = 2;
                    break;
                }
            }
            int p = vertData.length / 4;
            for (int vertNum = 0; vertNum < 4; ++vertNum) {
                float A = Float.intBitsToFloat(vertData[vertNum * p + a]);
                float B = Float.intBitsToFloat(vertData[vertNum * p + b]);
                for (int o = 0; o < 3; ++o) {
                    float v = Float.intBitsToFloat(vertData[vertNum * p + o]);
                    float scaler = 0.0625f;
                    ChiseledBlockBakedModel.quadMapping[myFace.ordinal()][vertNum][o * 2] = v * 0.0625f;
                    ChiseledBlockBakedModel.quadMapping[myFace.ordinal()][vertNum][o * 2 + 1] = (1.0f - v) * 0.0625f;
                }
                ChiseledBlockBakedModel.faceVertMap[myFace.method_10146()][vertNum] = ModelUtil.isZero(A) && ModelUtil.isZero(B) ? 0 : (ModelUtil.isZero(A) && ModelUtil.isOne(B) ? 3 : (ModelUtil.isOne(A) && ModelUtil.isZero(B) ? 1 : 2));
            }
        }
    }

    private static final class FaceBuildingState {
        private double regionBuildingAxis = -1.0;
        private double faceBuildingAxis = -1.0;
        private FaceRegion currentRegion;

        private FaceBuildingState() {
        }

        public double getRegionBuildingAxisValue() {
            return this.regionBuildingAxis;
        }

        public void setRegionBuildingAxisValue(double regionBuildingAxis) {
            this.regionBuildingAxis = regionBuildingAxis;
        }

        public double getFaceBuildingAxisValue() {
            return this.faceBuildingAxis;
        }

        public void setFaceBuildingAxisValue(double faceBuildingAxis) {
            this.faceBuildingAxis = faceBuildingAxis;
        }

        public FaceRegion getCurrentRegion() {
            return this.currentRegion;
        }

        public void setCurrentRegion(FaceRegion currentRegion) {
            this.currentRegion = currentRegion;
        }
    }
}

